<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     * EVIDÊNCIAS DAS TURMAS
     */
    public function up(): void
    {
        Schema::create('monitorias', function (Blueprint $table) {
            $table->foreignId('alfabetizadoresturma_id')->constrained()->cascadeOnDelete(); // Quem cadastrou
            $table->foreignId('observacoe_id')->constrained()->cascadeOnDelete();
            
            /*
            DADOS PARA MOSTRAR
            Bilhete (Contrato):
            Módulo (Contrato):
            Turno  (Contrato):
            Banco  (Contrato)::
            Iban   (Contrato):
            Total de alunos MF: Previsto (Cadastro)
            Total de alunos F: Previsto (Cadastro)
            */
            
            $table->dateTime('data_da_evidencia');
            
            // Bloco: Dados da entidade visitada GPS
            $table->string('lat')->default("0.00");
            $table->string('long')->default("0.00");
            $table->string('precisao')->default("0.00");
            $table->string('altitude')->default("0.00");
            // Bloco: Dados da entidade visitada
            $table->string('Fotografia_da_entidade_visitada',255);

            // Bloco: Dados da turma visitada (responsavel: alfabetizador | professor)
            $table->string('presenca_alfabetizador_professor'); // presente, ausente
            $table->string('foto_alfabetizador_professor',255)->default("ausentes.png"); // 
            $table->text('justificativa_da_ausencia_responsavel')->nullable();
            $table->string('nome_do_alfabetizador_professor_presente',100); //


            $table->string('presenca_alunos'); // presente, ausente
            $table->string('foto_alunos',255)->default("ausentes.png"); // 
            $table->text('justificativa_da_ausencia_alunos')->nullable(); // 
            
            $table->float('alunos_matriculados_mf'); //
            $table->float('alunos_matriculados_f'); //
            $table->float('alunos_presentes_mf'); //
            $table->float('alunos_presentes_f'); //
            $table->string('foto_da_lista_de_presenca',255); // 
           

            // Bloco: Controle de documentos.
            $table->string('caderno_de_plano_de_aulas',30); // verificado | não verificado
            $table->string('foto_do_caderno_de_plano_de_aulas',255)->nullable(); // 

            $table->string('diario_de_bordo',30); // verificado | não verificado
            $table->string('foto_do_diario_de_bordo',255)->nullable(); // 

            $table->string('folha_de_frequencia',30); // verificado | não verificado
            $table->string('foto_do_folha_de_frequencia',255)->nullable(); // 

             // Bloco: Outros documentos.
            $table->string('manual_do_professor',30)->default("não verificado"); // verificado | não verificado
            $table->string('material_dos_alunos',30)->default("não verificado"); // verificado | não verificado
            $table->string('guia_metodologico',30)->default("não verificado"); // verificado | não verificado
            
           
            $table->timestamps();
            $table->primary(['alfabetizadoresturma_id', 'observacoe_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('monitorias');
    }
};
